<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Ultimate_AI_WooCommerce{
    public $access_token, $payment_data, $UAI_PAYMENTS;
    public function __construct(){
        $this->UAI_PAYMENTS = new Ultimate_AI_Payments_Module();

        if( !$this->UAI_PAYMENTS->gateway_active('woocommerce') ) return;
    }
    
    public function create_checkout( $data ){
        $this->payment_data = $data;

        return $this->createOrder();
    }
    public function productExists( $pricing_id, $cycle = '' ){
        $args = array(
            'meta_query' => array(
                array(
                    'key' => 'pricing_id',
                    'value' => $pricing_id
                ),
            ),
            'post_type' => 'product',
            'posts_per_page' => 1
        );
        if( !empty($cycle) ){
            $args['meta_query'][] = array(
                'key' => 'payment_cycle',
                'value' => $cycle
            );
        }
        $posts = get_posts($args);
        if( $posts ){
            foreach( $posts as $post ){
                return $post->ID;
            }
        }else{
            return false;
        }
    }
    public function createOrder(){
        
        if( class_exists('WC_Product_Simple') ){
            
            $cycle = '';
            if( isset($this->payment_data['cycle']) ){
                $cycle = $this->payment_data['cycle'];
            }
            $product_id = $this->productExists($this->payment_data['pricing_id'], $cycle);

            if( $product_id ){
                $current_price = get_post_meta( $product_id, '_price', true );
                if( $this->payment_data['price'] != $current_price ){
                    update_post_meta( $product_id, '_price', $this->payment_data['price'] );
                    update_post_meta( $product_id, '_regular_price', $this->payment_data['price'] );
                }
                
            }else{
                $product = new WC_Product_Simple();
                
                $product->set_name( $this->payment_data['name'] . '-' . $cycle );
                $product->set_regular_price( $this->payment_data['price'] );
                $product->set_virtual( true );
                $product->update_meta_data('pricing_id', $this->payment_data['pricing_id']);
                if( $this->payment_data['package'] == 'subscription' ){
                    $product->update_meta_data('_ywsbs_subscription', 'yes');
                    $product->update_meta_data('_ywsbs_price_is_per', $cycle == 'monthly' ? 1 : 12);
                    $product->update_meta_data('_ywsbs_price_time_option', 'months');
                    $product->update_meta_data('payment_cycle', $cycle);
                }
                $product->save();
    
                $product_id = $product->get_id();
            }
            
            WC()->cart->empty_cart();
            
            WC()->cart->add_to_cart( $product_id );

            WC()->session->set( 'pricing_id' , $this->payment_data['pricing_id'] );
            return [
                'status' => 200,
                'message' => 'Checkout Session created!',
                'url' => wc_get_checkout_url(),
            ];
        }else{
            esc_html__( 'WooCommerce Checkout failed!', ULTIMATE_AI_SLUG );
        }
    }


    public function CreateOrderData( $order_details, $pricing_id ){

        $SUBSCRIPTION_MANAGER = new Ultimate_AI_Subscription();

        $package_type = $SUBSCRIPTION_MANAGER->getPackageType( $pricing_id );

        $subs = $order_details->get_meta('subscriptions');

        $current_user = wp_get_current_user();

        if( $package_type == 'subscription' ){
            $order = [
                'subscribed'        => true,
                'order_id'          => $order_details->get_id(), //this is the subscription id for paypal
                'subscription_id'   => $order_details->get_id(), //this is the subscription id for paypal
                'user_id'           => get_current_user_id(),
                'name'              => $current_user->display_name,
                'email'             => $current_user->user_email,
                'customer_id'       => $order_details->get_user_id(),
                'starts'            => get_post_meta( $subs[0], 'start_date', true ),
                'expiry'            => get_post_meta( $subs[0], 'payment_due_date', true ),
                // 'payment_method'    => $order_details->get_payment_method(),
                'payment_method'    => 'woocommerce',
                'plan_price'        => $order_details->get_total(),
                'pricing_id'        => $pricing_id,
                'payment_status'    => get_post_meta( $subs[0], 'status', true ),
                'country'           => $order_details->get_billing_country(),
                'address'           => $order_details->get_address(),
                'currency'          => $SUBSCRIPTION_MANAGER->getDefaultCurrency(),
            ];
        }elseif( $package_type == 'token' ){
            $order = [
                'subscribed'        => true,
                'user_id'           => get_current_user_id(),
                'order_id'          => $order_details->get_id(),
                'name'              => $current_user->display_name,
                'email'             => $current_user->user_email,
                'address'           => $order_details->get_address(),
                'customer_id'       => $order_details->get_user_id(),
                'starts'            => time(),
                'expiry'            => 'Unlimited',
                // 'payment_method'    => $order_details->get_payment_method(),
                'payment_method'    => 'woocommerce',
                'plan_price'        => $SUBSCRIPTION_MANAGER->getpackagePrice( $pricing_id ),
                'pricing_id'        => $pricing_id,
                'payment_status'    => 'active',
                'country'           => $order_details->get_billing_country(),
                'currency'          => $SUBSCRIPTION_MANAGER->getDefaultCurrency(),
            ];

        }
        return $order;
    }

    public function update_payment_methods(){
        $value = Ultimate_AI_Filter_Controller($_POST['methods']);
        $res = update_option( 'ultimate_ai_payment_method', $value, true );
        wp_send_json( $res, 200 );
    }


    public function cancelSubscription( $subscription_id ){
        if( !$this->UAI_PAYMENTS->gateway_active('paypal') ) return;

        $args = [
            'method'      => 'POST',
            'headers' => [
                'Authorization'=> 'Bearer ' . $this->access_token,
            ],
            'body' => json_encode([[
                "reason" => 'user cancel'
            ]]),
        ];

        try{
            $response = wp_remote_get( $this->baseURL() . '/v1/billing/subscriptions/' . $subscription_id . '/cancel', $args );

            $res_body = json_decode( wp_remote_retrieve_body( $response ) );
            
            $error = $this->responseErrorHandler( $response );
            if( $error ){
                return $error;
            }
            return [
                'status' => 200,
                'message' => 'Subscription Cancelled'
            ];
        }catch( Exception $e ){
            return $e->getMessage();
        }
    }
}